<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>{{ $title }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            direction: rtl;
            font-size: 12px;
            color: #333;
            line-height: 1.6;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 3px solid #f59e0b;
        }
        .header h1 {
            font-size: 24px;
            color: #1f2937;
            margin-bottom: 10px;
            font-weight: bold;
        }
        .header p {
            color: #6b7280;
            font-size: 14px;
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table th {
            background-color: #f59e0b;
            color: white;
            padding: 12px 8px;
            text-align: right;
            font-weight: bold;
            border: 1px solid #d97706;
        }
        table td {
            padding: 10px 8px;
            border: 1px solid #e5e7eb;
            text-align: right;
        }
        table tr:nth-child(even) {
            background-color: #f9fafb;
        }
        .summary {
            margin-top: 20px;
            padding: 15px;
            background-color: #f5f5f5;
            border-radius: 5px;
        }
        .summary-item {
            margin: 5px 0;
            font-size: 13px;
        }
        .summary-highlight {
            font-size: 16px;
            font-weight: bold;
            color: #059669;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 2px solid #d1d5db;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
            text-align: center;
            color: #6b7280;
            font-size: 11px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
        <p>من {{ $data['start_date'] }} إلى {{ $data['end_date'] }}</p>
        <p>تاريخ التقرير: {{ now()->format('Y-m-d H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>رقم الطلب</th>
                <th>تاريخ الطلب</th>
                <th>العميل</th>
                <th>الخدمة</th>
                <th>سعر الخدمة</th>
                <th>رسوم التطبيق</th>
                <th>الخصم</th>
                <th>إجمالي الطلب</th>
                <th>الحالة</th>
            </tr>
        </thead>
        <tbody>
            @forelse($orders as $order)
                <tr>
                    <td>{{ $order->order_number }}</td>
                    <td>{{ $order->created_at->format('Y-m-d') }}</td>
                    <td>{{ $order->client->name ?? '-' }}</td>
                    <td>{{ $order->service ? $order->service->getTranslation('name', 'ar') : '-' }}</td>
                    <td>{{ number_format($order->price, 2) }} ر.س</td>
                    <td>{{ number_format($order->fee, 2) }} ر.س</td>
                    <td>{{ number_format($order->discount, 2) }} ر.س</td>
                    <td><strong>{{ number_format($order->total, 2) }} ر.س</strong></td>
                    <td>
                        @if($order->status === 'completed') مكتمل
                        @elseif($order->status === 'cancelled') ملغي
                        @elseif($order->status === 'confirmed') مؤكد
                        @elseif($order->status === 'pending') قيد الانتظار
                        @elseif($order->status === 'in_progress') قيد التنفيذ
                        @else {{ $order->status }}
                        @endif
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="9" style="text-align: center; padding: 20px;">لا توجد مبيعات</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="summary">
        <div class="summary-item"><strong>عدد الطلبات:</strong> {{ $totalOrders }}</div>
        <div class="summary-item"><strong>إجمالي سعر الخدمات:</strong> {{ number_format($totalPrice, 2) }} ر.س</div>
        <div class="summary-item"><strong>إجمالي رسوم التطبيق:</strong> {{ number_format($totalFees, 2) }} ر.س</div>
        <div class="summary-item"><strong>إجمالي الخصومات:</strong> {{ number_format($totalDiscount, 2) }} ر.س</div>
        <div class="summary-item"><strong>إجمالي قيمة الطلبات:</strong> {{ number_format($totalAmount, 2) }} ر.س</div>
        <div class="summary-item"><strong>رسوم التطبيق من المكتمل فقط:</strong> {{ number_format($completedFees, 2) }} ر.س</div>
        <div class="summary-item"><strong>متوسط قيمة الطلب:</strong> {{ $totalOrders > 0 ? number_format($totalAmount / $totalOrders, 2) : 0 }} ر.س</div>
        <div class="summary-highlight">صافي ربح التطبيق (رسوم الطلبات المكتملة): {{ number_format($completedFees, 2) }} ر.س</div>
    </div>

    <div class="footer">
        <p>تم إنشاء هذا التقرير تلقائياً من نظام بيتي</p>
    </div>
</body>
</html>
