<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>{{ $title }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            direction: rtl;
            font-size: 11px;
            color: #333;
            line-height: 1.6;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 3px solid #f59e0b;
        }
        .header h1 {
            font-size: 24px;
            color: #1f2937;
            margin-bottom: 10px;
            font-weight: bold;
        }
        .header p {
            color: #6b7280;
            font-size: 14px;
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table th {
            background-color: #f59e0b;
            color: white;
            padding: 10px 6px;
            text-align: right;
            font-weight: bold;
            border: 1px solid #d97706;
            font-size: 10px;
        }
        table td {
            padding: 8px 6px;
            border: 1px solid #e5e7eb;
            text-align: right;
            font-size: 10px;
        }
        table tr:nth-child(even) {
            background-color: #f9fafb;
        }
        .summary {
            margin-top: 20px;
            padding: 15px;
            background-color: #f5f5f5;
            border-radius: 5px;
        }
        .summary-item {
            margin: 5px 0;
            font-size: 13px;
        }
        .summary-highlight {
            font-size: 16px;
            font-weight: bold;
            color: #059669;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 2px solid #d1d5db;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
            text-align: center;
            color: #6b7280;
            font-size: 11px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
        <p>من {{ $data['start_date'] }} إلى {{ $data['end_date'] }}</p>
        <p>تاريخ التقرير: {{ now()->format('Y-m-d H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>رقم الطلب</th>
                <th>العميل</th>
                <th>الخدمة</th>
                <th>الفني</th>
                <th>النوع</th>
                <th>الحالة</th>
                <th>سعر الخدمة</th>
                <th>رسوم التطبيق</th>
                <th>مستحق الفني</th>
                <th>الخصم</th>
                <th>إجمالي الطلب</th>
                <th>تاريخ الإنشاء</th>
            </tr>
        </thead>
        <tbody>
            @forelse($orders as $order)
                <tr>
                    <td>{{ $order->order_number }}</td>
                    <td>{{ $order->client->name ?? '-' }}</td>
                    <td>{{ $order->service ? $order->service->getTranslation('name', 'ar') : '-' }}</td>
                    <td>{{ $order->technician->name ?? '-' }}</td>
                    <td>{{ $order->type === 'urgent' ? 'مستعجل' : 'عادي' }}</td>
                    <td>
                        @if($order->status === 'pending') قيد الانتظار
                        @elseif($order->status === 'confirmed') مؤكد
                        @elseif($order->status === 'in_progress') قيد التنفيذ
                        @elseif($order->status === 'completed') مكتمل
                        @elseif($order->status === 'cancelled') ملغي
                        @else {{ $order->status }}
                        @endif
                    </td>
                    <td>{{ number_format($order->price, 2) }} ر.س</td>
                    <td>{{ number_format($order->fee, 2) }} ر.س</td>
                    <td>{{ number_format($order->technician_commission ?? 0, 2) }} ر.س</td>
                    <td>{{ number_format($order->discount, 2) }} ر.س</td>
                    <td><strong>{{ number_format($order->total, 2) }} ر.س</strong></td>
                    <td>{{ $order->created_at->format('Y-m-d H:i') }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="12" style="text-align: center; padding: 20px;">لا توجد طلبات</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="summary">
        <div class="summary-item"><strong>إجمالي الطلبات:</strong> {{ $orders->count() }}</div>
        <div class="summary-item"><strong>إجمالي سعر الخدمات:</strong> {{ number_format($totalPrice, 2) }} ر.س</div>
        <div class="summary-item"><strong>إجمالي رسوم التطبيق:</strong> {{ number_format($totalFees, 2) }} ر.س</div>
        <div class="summary-item"><strong>إجمالي مستحقات الفنيين:</strong> {{ number_format($totalCommission ?? 0, 2) }} ر.س</div>
        <div class="summary-item"><strong>إجمالي الخصومات:</strong> {{ number_format($totalDiscount, 2) }} ر.س</div>
        <div class="summary-item"><strong>إجمالي قيمة الطلبات:</strong> {{ number_format($totalAmount, 2) }} ر.س</div>
        <div class="summary-highlight">صافي ربح التطبيق (الرسوم): {{ number_format($totalFees, 2) }} ر.س</div>
    </div>

    <div class="footer">
        <p>تم إنشاء هذا التقرير تلقائياً من نظام بيتي</p>
    </div>
</body>
</html>
