<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>{{ $title }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            direction: rtl;
            font-size: 12px;
            color: #333;
            line-height: 1.6;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 3px solid #f59e0b;
        }
        .header h1 {
            font-size: 24px;
            color: #1f2937;
            margin-bottom: 10px;
            font-weight: bold;
        }
        .header p {
            color: #6b7280;
            font-size: 14px;
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table th {
            background-color: #f59e0b;
            color: white;
            padding: 12px 8px;
            text-align: right;
            font-weight: bold;
            border: 1px solid #d97706;
        }
        table td {
            padding: 10px 8px;
            border: 1px solid #e5e7eb;
            text-align: right;
        }
        table tr:nth-child(even) {
            background-color: #f9fafb;
        }
        .summary {
            margin-top: 20px;
            padding: 15px;
            background-color: #f5f5f5;
            border-radius: 5px;
        }
        .summary-item {
            margin: 5px 0;
            font-size: 13px;
        }
        .summary-highlight {
            font-size: 16px;
            font-weight: bold;
            color: #059669;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 2px solid #d1d5db;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
            text-align: center;
            color: #6b7280;
            font-size: 11px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
        <p>من {{ $data['start_date'] }} إلى {{ $data['end_date'] }}</p>
        <p>تاريخ التقرير: {{ now()->format('Y-m-d H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>الاسم</th>
                <th>البريد الإلكتروني</th>
                <th>رقم الهاتف</th>
                <th>الجنس</th>
                <th>المدينة</th>
                <th>عدد الطلبات</th>
                <th>إجمالي المدفوع</th>
                <th>رسوم التطبيق</th>
                <th>تاريخ التسجيل</th>
                <th>الحالة</th>
            </tr>
        </thead>
        <tbody>
            @forelse($clients as $client)
                <tr>
                    <td>{{ $client->name }}</td>
                    <td>{{ $client->email }}</td>
                    <td>{{ $client->phone ?? '-' }}</td>
                    <td>{{ $client->gender === 'Male' ? 'ذكر' : ($client->gender === 'Female' ? 'أنثى' : '-') }}</td>
                    <td>{{ $client->city ?? '-' }}</td>
                    <td>{{ $client->orders_count ?? 0 }}</td>
                    <td>{{ number_format($client->orders_total ?? 0, 2) }} ر.س</td>
                    <td>{{ number_format($client->orders_fee ?? 0, 2) }} ر.س</td>
                    <td>{{ $client->created_at->format('Y-m-d') }}</td>
                    <td>{{ $client->is_active ? 'نشط' : 'غير نشط' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="10" style="text-align: center; padding: 20px;">لا يوجد عملاء</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="summary">
        <div class="summary-item"><strong>إجمالي العملاء:</strong> {{ $clients->count() }}</div>
        <div class="summary-item"><strong>العملاء النشطين:</strong> {{ $clients->where('is_active', true)->count() }}</div>
        <div class="summary-item"><strong>إجمالي المدفوع من العملاء:</strong> {{ number_format($clients->sum('orders_total'), 2) }} ر.س</div>
        <div class="summary-highlight">ربح التطبيق من العملاء (الرسوم): {{ number_format($clients->sum('orders_fee'), 2) }} ر.س</div>
    </div>

    <div class="footer">
        <p>تم إنشاء هذا التقرير تلقائياً من نظام بيتي</p>
    </div>
</body>
</html>
