<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقرير الاشتراكات</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Cairo', Arial, sans-serif;
            direction: rtl;
            font-size: 12px;
            color: #333;
            line-height: 1.6;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 3px solid #f59e0b;
        }
        
        .header h1 {
            font-size: 24px;
            color: #1f2937;
            margin-bottom: 10px;
        }
        
        .header .date {
            color: #6b7280;
            font-size: 14px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        table th {
            background-color: #f59e0b;
            color: white;
            padding: 12px 8px;
            text-align: right;
            font-weight: 700;
            border: 1px solid #d97706;
            font-size: 11px;
        }
        
        table td {
            padding: 10px 8px;
            border: 1px solid #e5e7eb;
            text-align: right;
            font-size: 11px;
        }
        
        table tr:nth-child(even) {
            background-color: #f9fafb;
        }
        
        table tr:hover {
            background-color: #fef3c7;
        }
        
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
            text-align: center;
            color: #6b7280;
            font-size: 11px;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: 600;
        }
        
        .badge-success {
            background-color: #10b981;
            color: white;
        }
        
        .badge-danger {
            background-color: #ef4444;
            color: white;
        }
        
        .badge-warning {
            background-color: #f59e0b;
            color: white;
        }
        
        .badge-gray {
            background-color: #6b7280;
            color: white;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>تقرير الاشتراكات</h1>
        <div class="date">تاريخ التقرير: {{ now()->format('Y-m-d H:i') }}</div>
    </div>
    
    <table>
        <thead>
            <tr>
                <th>اسم العميل</th>
                <th>الباقة</th>
                <th>نوع الاشتراك</th>
                <th>تاريخ البداية</th>
                <th>تاريخ الانتهاء</th>
                <th>الأيام المتبقية</th>
                <th>الحالة</th>
                <th>المبلغ المدفوع</th>
                <th>طريقة الدفع</th>
                <th>حالة الدفع</th>
            </tr>
        </thead>
        <tbody>
            @forelse($subscriptions as $subscription)
                @php
                    $remainingDays = '-';
                    if ($subscription->status === 'active' && $subscription->end_date) {
                        $days = now()->startOfDay()->diffInDays($subscription->end_date, false);
                        $remainingDays = $days >= 0 ? $days . ' يوم' : 'منتهي';
                    }
                    
                    $statusColors = [
                        'active' => 'badge-success',
                        'expired' => 'badge-danger',
                        'cancelled' => 'badge-gray',
                        'suspended' => 'badge-warning',
                    ];
                    
                    $statusLabels = [
                        'active' => 'نشط',
                        'expired' => 'منتهي',
                        'cancelled' => 'ملغي',
                        'suspended' => 'معلق',
                    ];
                    
                    $paymentStatusColors = [
                        'paid' => 'badge-success',
                        'pending' => 'badge-warning',
                        'refunded' => 'badge-danger',
                    ];
                    
                    $paymentStatusLabels = [
                        'paid' => 'مدفوع',
                        'pending' => 'معلق',
                        'refunded' => 'مسترد',
                    ];
                @endphp
                <tr>
                    <td>{{ $subscription->client->name ?? '-' }}</td>
                    <td>
                        @if($subscription->package)
                            {{ $subscription->package->getTranslation('name', 'ar') }}
                        @else
                            -
                        @endif
                    </td>
                    <td>
                        @if($subscription->package && $subscription->package->duration_days)
                            {{ $subscription->package->duration_days == 365 ? 'سنوي' : 'نصف سنوي' }}
                        @else
                            -
                        @endif
                    </td>
                    <td>{{ $subscription->start_date->format('Y-m-d') }}</td>
                    <td>{{ $subscription->end_date->format('Y-m-d') }}</td>
                    <td>{{ $remainingDays }}</td>
                    <td>
                        <span class="badge {{ $statusColors[$subscription->status] ?? 'badge-gray' }}">
                            {{ $statusLabels[$subscription->status] ?? $subscription->status }}
                        </span>
                    </td>
                    <td>{{ number_format($subscription->amount_paid, 2) }} ر.س</td>
                    <td>
                        @php
                            $paymentMethods = [
                                'cash' => 'كاش',
                                'visa' => 'فيزا',
                                'mastercard' => 'ماستركارد',
                                'mada' => 'مدى',
                                'transfer' => 'تحويل بنكي',
                                'other' => 'أخرى',
                            ];
                        @endphp
                        {{ $paymentMethods[$subscription->payment_method] ?? ($subscription->payment_method ?? '-') }}
                    </td>
                    <td>
                        <span class="badge {{ $paymentStatusColors[$subscription->payment_status] ?? 'badge-gray' }}">
                            {{ $paymentStatusLabels[$subscription->payment_status] ?? $subscription->payment_status }}
                        </span>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="10" style="text-align: center; padding: 20px;">
                        لا توجد بيانات للعرض
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="footer">
        <p>إجمالي عدد الاشتراكات: {{ $subscriptions->count() }}</p>
        <p>إجمالي المبلغ المدفوع: {{ number_format($subscriptions->sum('amount_paid'), 2) }} ر.س</p>
        <p>تم إنشاء التقرير بواسطة نظام إدارة الخدمات</p>
    </div>
</body>
</html>



