<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقرير الخدمات</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Cairo', Arial, sans-serif;
            direction: rtl;
            font-size: 12px;
            color: #333;
            line-height: 1.6;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 3px solid #f59e0b;
        }
        
        .header h1 {
            font-size: 24px;
            color: #1f2937;
            margin-bottom: 10px;
        }
        
        .header .date {
            color: #6b7280;
            font-size: 14px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        table th {
            background-color: #f59e0b;
            color: white;
            padding: 12px 8px;
            text-align: right;
            font-weight: 700;
            border: 1px solid #d97706;
        }
        
        table td {
            padding: 10px 8px;
            border: 1px solid #e5e7eb;
            text-align: right;
        }
        
        table tr:nth-child(even) {
            background-color: #f9fafb;
        }
        
        table tr:hover {
            background-color: #fef3c7;
        }
        
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
            text-align: center;
            color: #6b7280;
            font-size: 11px;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: 600;
        }
        
        .badge-success {
            background-color: #10b981;
            color: white;
        }
        
        .badge-danger {
            background-color: #ef4444;
            color: white;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>تقرير الخدمات</h1>
        <div class="date">تاريخ التقرير: {{ now()->format('Y-m-d H:i') }}</div>
    </div>
    
    <table>
        <thead>
            <tr>
                <th>اسم الخدمة (عربي)</th>
                <th>اسم الخدمة (إنجليزي)</th>
                <th>القسم</th>
                <th>السعر</th>
                <th>النقاط المكتسبة</th>
                <th>الحالة</th>
                <th>ترتيب العرض</th>
                <th>تاريخ الإنشاء</th>
            </tr>
        </thead>
        <tbody>
            @forelse($services as $service)
                <tr>
                    <td>{{ $service->getTranslation('name', 'ar') }}</td>
                    <td>{{ $service->getTranslation('name', 'en') }}</td>
                    <td>
                        @if($service->category)
                            {{ $service->category->getTranslation('name', 'ar') }}
                        @else
                            -
                        @endif
                    </td>
                    <td>{{ number_format($service->price, 2) }} ر.س</td>
                    <td>{{ $service->points ?? 0 }} نقطة</td>
                    <td>
                        <span class="badge {{ $service->is_active ? 'badge-success' : 'badge-danger' }}">
                            {{ $service->is_active ? 'نشط' : 'غير نشط' }}
                        </span>
                    </td>
                    <td>{{ $service->sort_order ?? 0 }}</td>
                    <td>{{ $service->created_at->format('Y-m-d') }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" style="text-align: center; padding: 20px;">
                        لا توجد بيانات للعرض
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="footer">
        <p>إجمالي عدد الخدمات: {{ $services->count() }}</p>
        <p>إجمالي السعر: {{ number_format($services->sum('price'), 2) }} ر.س</p>
        <p>تم إنشاء التقرير بواسطة نظام إدارة الخدمات</p>
    </div>
</body>
</html>



