<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقرير العملاء</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Cairo', Arial, sans-serif;
            direction: rtl;
            font-size: 12px;
            color: #333;
            line-height: 1.6;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 3px solid #f59e0b;
        }
        
        .header h1 {
            font-size: 24px;
            color: #1f2937;
            margin-bottom: 10px;
        }
        
        .header .date {
            color: #6b7280;
            font-size: 14px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        table th {
            background-color: #f59e0b;
            color: white;
            padding: 12px 8px;
            text-align: right;
            font-weight: 700;
            border: 1px solid #d97706;
        }
        
        table td {
            padding: 10px 8px;
            border: 1px solid #e5e7eb;
            text-align: right;
        }
        
        table tr:nth-child(even) {
            background-color: #f9fafb;
        }
        
        table tr:hover {
            background-color: #fef3c7;
        }
        
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
            text-align: center;
            color: #6b7280;
            font-size: 11px;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: 600;
        }
        
        .badge-success {
            background-color: #10b981;
            color: white;
        }
        
        .badge-danger {
            background-color: #ef4444;
            color: white;
        }
        
        .badge-warning {
            background-color: #f59e0b;
            color: white;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>تقرير العملاء</h1>
        <div class="date">تاريخ التقرير: {{ now()->format('Y-m-d H:i') }}</div>
    </div>
    
    <table>
        <thead>
            <tr>
                <th>الاسم الكامل</th>
                <th>البريد الإلكتروني</th>
                <th>رقم الهاتف</th>
                <th>المدينة</th>
                <th>الجنس</th>
                <th>الحالة</th>
                <th>رصيد النقاط</th>
                <th>الباقة الحالية</th>
                <th>تاريخ انتهاء الاشتراك</th>
                <th>تاريخ التسجيل</th>
            </tr>
        </thead>
        <tbody>
            @forelse($clients as $client)
                <tr>
                    <td>{{ $client->name }}</td>
                    <td>{{ $client->email }}</td>
                    <td>{{ $client->phone ?? '-' }}</td>
                    <td>{{ $client->city ?? '-' }}</td>
                    <td>
                        @if($client->gender === 'Male')
                            ذكر
                        @elseif($client->gender === 'Female')
                            أنثى
                        @else
                            -
                        @endif
                    </td>
                    <td>
                        <span class="badge {{ $client->is_active ? 'badge-success' : 'badge-danger' }}">
                            {{ $client->is_active ? 'نشط' : 'غير نشط' }}
                        </span>
                    </td>
                    <td>{{ $client->points_balance ?? 0 }} نقطة</td>
                    <td>
                        @if($client->active_subscription && $client->active_subscription->package)
                            {{ $client->active_subscription->package->getTranslation('name', 'ar') }}
                        @else
                            -
                        @endif
                    </td>
                    <td>
                        @if($client->active_subscription && $client->active_subscription->end_date)
                            {{ $client->active_subscription->end_date->format('Y-m-d') }}
                        @else
                            -
                        @endif
                    </td>
                    <td>{{ $client->created_at->format('Y-m-d') }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="10" style="text-align: center; padding: 20px;">
                        لا توجد بيانات للعرض
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="footer">
        <p>إجمالي عدد العملاء: {{ $clients->count() }}</p>
        <p>تم إنشاء التقرير بواسطة نظام إدارة الخدمات</p>
    </div>
</body>
</html>



