<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create permissions with translations
        $permissions = [
            // User management
            [
                'name' => 'view_users',
                'name_ar' => 'عرض المستخدمين',
                'name_en' => 'View Users',
            ],
            [
                'name' => 'create_users',
                'name_ar' => 'إنشاء مستخدمين',
                'name_en' => 'Create Users',
            ],
            [
                'name' => 'edit_users',
                'name_ar' => 'تعديل المستخدمين',
                'name_en' => 'Edit Users',
            ],
            [
                'name' => 'delete_users',
                'name_ar' => 'حذف المستخدمين',
                'name_en' => 'Delete Users',
            ],

            // Client management
            [
                'name' => 'view_clients',
                'name_ar' => 'عرض العملاء',
                'name_en' => 'View Clients',
            ],
            [
                'name' => 'create_clients',
                'name_ar' => 'إنشاء عملاء',
                'name_en' => 'Create Clients',
            ],
            [
                'name' => 'edit_clients',
                'name_ar' => 'تعديل العملاء',
                'name_en' => 'Edit Clients',
            ],
            [
                'name' => 'delete_clients',
                'name_ar' => 'حذف العملاء',
                'name_en' => 'Delete Clients',
            ],

            // Technician management
            [
                'name' => 'view_technicians',
                'name_ar' => 'عرض الفنيين',
                'name_en' => 'View Technicians',
            ],
            [
                'name' => 'create_technicians',
                'name_ar' => 'إنشاء فنيين',
                'name_en' => 'Create Technicians',
            ],
            [
                'name' => 'edit_technicians',
                'name_ar' => 'تعديل الفنيين',
                'name_en' => 'Edit Technicians',
            ],
            [
                'name' => 'delete_technicians',
                'name_ar' => 'حذف الفنيين',
                'name_en' => 'Delete Technicians',
            ],

            // Service management
            [
                'name' => 'view_services',
                'name_ar' => 'عرض الخدمات',
                'name_en' => 'View Services',
            ],
            [
                'name' => 'create_services',
                'name_ar' => 'إنشاء خدمات',
                'name_en' => 'Create Services',
            ],
            [
                'name' => 'edit_services',
                'name_ar' => 'تعديل الخدمات',
                'name_en' => 'Edit Services',
            ],
            [
                'name' => 'delete_services',
                'name_ar' => 'حذف الخدمات',
                'name_en' => 'Delete Services',
            ],

            // Category management
            [
                'name' => 'view_categories',
                'name_ar' => 'عرض الأقسام',
                'name_en' => 'View Categories',
            ],
            [
                'name' => 'create_categories',
                'name_ar' => 'إنشاء أقسام',
                'name_en' => 'Create Categories',
            ],
            [
                'name' => 'edit_categories',
                'name_ar' => 'تعديل الأقسام',
                'name_en' => 'Edit Categories',
            ],
            [
                'name' => 'delete_categories',
                'name_ar' => 'حذف الأقسام',
                'name_en' => 'Delete Categories',
            ],

            // Order management
            [
                'name' => 'view_orders',
                'name_ar' => 'عرض الطلبات',
                'name_en' => 'View Orders',
            ],
            [
                'name' => 'create_orders',
                'name_ar' => 'إنشاء طلبات',
                'name_en' => 'Create Orders',
            ],
            [
                'name' => 'edit_orders',
                'name_ar' => 'تعديل الطلبات',
                'name_en' => 'Edit Orders',
            ],
            [
                'name' => 'delete_orders',
                'name_ar' => 'حذف الطلبات',
                'name_en' => 'Delete Orders',
            ],

            // Package management
            [
                'name' => 'view_packages',
                'name_ar' => 'عرض الباقات',
                'name_en' => 'View Packages',
            ],
            [
                'name' => 'create_packages',
                'name_ar' => 'إنشاء باقات',
                'name_en' => 'Create Packages',
            ],
            [
                'name' => 'edit_packages',
                'name_ar' => 'تعديل الباقات',
                'name_en' => 'Edit Packages',
            ],
            [
                'name' => 'delete_packages',
                'name_ar' => 'حذف الباقات',
                'name_en' => 'Delete Packages',
            ],

            // Subscription management
            [
                'name' => 'view_subscriptions',
                'name_ar' => 'عرض الاشتراكات',
                'name_en' => 'View Subscriptions',
            ],
            [
                'name' => 'create_subscriptions',
                'name_ar' => 'إنشاء اشتراكات',
                'name_en' => 'Create Subscriptions',
            ],
            [
                'name' => 'edit_subscriptions',
                'name_ar' => 'تعديل الاشتراكات',
                'name_en' => 'Edit Subscriptions',
            ],
            [
                'name' => 'delete_subscriptions',
                'name_ar' => 'حذف الاشتراكات',
                'name_en' => 'Delete Subscriptions',
            ],

            // Point Transaction management
            [
                'name' => 'view_point_transactions',
                'name_ar' => 'عرض معاملات النقاط',
                'name_en' => 'View Point Transactions',
            ],
            [
                'name' => 'create_point_transactions',
                'name_ar' => 'إنشاء معاملات نقاط',
                'name_en' => 'Create Point Transactions',
            ],
            [
                'name' => 'edit_point_transactions',
                'name_ar' => 'تعديل معاملات النقاط',
                'name_en' => 'Edit Point Transactions',
            ],
            [
                'name' => 'delete_point_transactions',
                'name_ar' => 'حذف معاملات النقاط',
                'name_en' => 'Delete Point Transactions',
            ],

            // Rating management
            [
                'name' => 'view_ratings',
                'name_ar' => 'عرض التقييمات',
                'name_en' => 'View Ratings',
            ],
            [
                'name' => 'create_ratings',
                'name_ar' => 'إنشاء تقييمات',
                'name_en' => 'Create Ratings',
            ],
            [
                'name' => 'edit_ratings',
                'name_ar' => 'تعديل التقييمات',
                'name_en' => 'Edit Ratings',
            ],
            [
                'name' => 'delete_ratings',
                'name_ar' => 'حذف التقييمات',
                'name_en' => 'Delete Ratings',
            ],

            // Additional Facility management
            [
                'name' => 'view_additional_facilities',
                'name_ar' => 'عرض المرافق الإضافية',
                'name_en' => 'View Additional Facilities',
            ],
            [
                'name' => 'create_additional_facilities',
                'name_ar' => 'إنشاء مرافق إضافية',
                'name_en' => 'Create Additional Facilities',
            ],
            [
                'name' => 'edit_additional_facilities',
                'name_ar' => 'تعديل المرافق الإضافية',
                'name_en' => 'Edit Additional Facilities',
            ],
            [
                'name' => 'delete_additional_facilities',
                'name_ar' => 'حذف المرافق الإضافية',
                'name_en' => 'Delete Additional Facilities',
            ],

            // Property Type management
            [
                'name' => 'view_property_types',
                'name_ar' => 'عرض أنواع العقارات',
                'name_en' => 'View Property Types',
            ],
            [
                'name' => 'create_property_types',
                'name_ar' => 'إنشاء أنواع عقارات',
                'name_en' => 'Create Property Types',
            ],
            [
                'name' => 'edit_property_types',
                'name_ar' => 'تعديل أنواع العقارات',
                'name_en' => 'Edit Property Types',
            ],
            [
                'name' => 'delete_property_types',
                'name_ar' => 'حذف أنواع العقارات',
                'name_en' => 'Delete Property Types',
            ],

            // Role & Permission management
            [
                'name' => 'view_roles',
                'name_ar' => 'عرض الأدوار',
                'name_en' => 'View Roles',
            ],
            [
                'name' => 'create_roles',
                'name_ar' => 'إنشاء أدوار',
                'name_en' => 'Create Roles',
            ],
            [
                'name' => 'edit_roles',
                'name_ar' => 'تعديل الأدوار',
                'name_en' => 'Edit Roles',
            ],
            [
                'name' => 'delete_roles',
                'name_ar' => 'حذف الأدوار',
                'name_en' => 'Delete Roles',
            ],
            [
                'name' => 'view_permissions',
                'name_ar' => 'عرض الصلاحيات',
                'name_en' => 'View Permissions',
            ],
            [
                'name' => 'create_permissions',
                'name_ar' => 'إنشاء صلاحيات',
                'name_en' => 'Create Permissions',
            ],
            [
                'name' => 'edit_permissions',
                'name_ar' => 'تعديل الصلاحيات',
                'name_en' => 'Edit Permissions',
            ],
            [
                'name' => 'delete_permissions',
                'name_ar' => 'حذف الصلاحيات',
                'name_en' => 'Delete Permissions',
            ],

            // Reports management
            [
                'name' => 'view_reports',
                'name_ar' => 'عرض التقارير',
                'name_en' => 'View Reports',
            ],
            [
                'name' => 'export_reports',
                'name_ar' => 'تصدير التقارير',
                'name_en' => 'Export Reports',
            ],

            // Settings management
            [
                'name' => 'view_settings',
                'name_ar' => 'عرض الإعدادات',
                'name_en' => 'View Settings',
            ],
            [
                'name' => 'edit_settings',
                'name_ar' => 'تعديل الإعدادات',
                'name_en' => 'Edit Settings',
            ],

            // Notifications management
            [
                'name' => 'send_notifications',
                'name_ar' => 'إرسال إشعارات',
                'name_en' => 'Send Notifications',
            ],
        ];

        foreach ($permissions as $permissionData) {
            $permission = Permission::firstOrCreate(
                ['name' => $permissionData['name']],
                [
                    'name_ar' => $permissionData['name_ar'],
                    'name_en' => $permissionData['name_en'],
                ]
            );
            
            // Update existing permissions with translations if they don't have them
            if (!$permission->name_ar || !$permission->name_en) {
                $permission->update([
                    'name_ar' => $permissionData['name_ar'],
                    'name_en' => $permissionData['name_en'],
                ]);
            }
        }

        // Create roles and assign permissions

        // Super Admin - has all permissions
        $superAdmin = Role::firstOrCreate(['name' => 'super_admin']);
        $superAdmin->givePermissionTo(Permission::all());

        // Admin - has most permissions except role/permission management
        $admin = Role::firstOrCreate(['name' => 'admin']);
        $admin->givePermissionTo([
            'view_users', 'create_users', 'edit_users', 'delete_users',
            'view_clients', 'create_clients', 'edit_clients', 'delete_clients',
            'view_technicians', 'create_technicians', 'edit_technicians', 'delete_technicians',
            'view_services', 'create_services', 'edit_services', 'delete_services',
            'view_categories', 'create_categories', 'edit_categories', 'delete_categories',
            'view_orders', 'create_orders', 'edit_orders', 'delete_orders',
            'view_packages', 'create_packages', 'edit_packages', 'delete_packages',
            'view_subscriptions', 'create_subscriptions', 'edit_subscriptions', 'delete_subscriptions',
            'view_point_transactions', 'create_point_transactions', 'edit_point_transactions', 'delete_point_transactions',
            'view_ratings', 'create_ratings', 'edit_ratings', 'delete_ratings',
            'view_additional_facilities', 'create_additional_facilities', 'edit_additional_facilities', 'delete_additional_facilities',
            'view_property_types', 'create_property_types', 'edit_property_types', 'delete_property_types',
            'view_reports', 'export_reports',
            'view_settings', 'edit_settings',
            'send_notifications',
            'view_roles',
        ]);

        // Moderator - can view and edit but not delete
        $moderator = Role::firstOrCreate(['name' => 'moderator']);
        $moderator->givePermissionTo([
            'view_users',
            'view_clients', 'create_clients', 'edit_clients',
            'view_technicians', 'create_technicians', 'edit_technicians',
            'view_services',
            'view_categories',
        ]);
    }
}





