<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('point_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['earned', 'spent', 'expired', 'admin_adjustment'])->default('earned');
            $table->integer('points');
            $table->string('description')->nullable();
            $table->string('reference_type')->nullable(); // مثل: 'subscription', 'service', 'manual'
            $table->unsignedBigInteger('reference_id')->nullable();
            $table->integer('balance_before')->default(0);
            $table->integer('balance_after')->default(0);
            $table->timestamps();

            $table->index(['client_id', 'type']);
            $table->index(['reference_type', 'reference_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('point_transactions');
    }
};





