<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Convert existing string data to JSON format
        $features = DB::table('package_features')->get();

        foreach ($features as $feature) {
            DB::table('package_features')
                ->where('id', $feature->id)
                ->update([
                    'feature' => json_encode(['ar' => $feature->feature ?? '', 'en' => ''], JSON_UNESCAPED_UNICODE),
                ]);
        }

        Schema::table('package_features', function (Blueprint $table) {
            $table->json('feature')->change();
        });
    }

    public function down(): void
    {
        Schema::table('package_features', function (Blueprint $table) {
            $table->string('feature')->change();
        });
    }
};
