<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Convert existing string data to JSON format
        $services = DB::table('services')->get();
        
        foreach ($services as $service) {
            $nameData = [
                'ar' => $service->name ?? '',
                'en' => '',
            ];
            
            $descriptionData = $service->description ? [
                'ar' => $service->description,
                'en' => '',
            ] : null;
            
            DB::table('services')
                ->where('id', $service->id)
                ->update([
                    'name' => json_encode($nameData, JSON_UNESCAPED_UNICODE),
                    'description' => $descriptionData ? json_encode($descriptionData, JSON_UNESCAPED_UNICODE) : null,
                ]);
        }
        
        // Change column types
        Schema::table('services', function (Blueprint $table) {
            $table->json('name')->change();
            $table->json('description')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('services', function (Blueprint $table) {
            $table->string('name')->change();
            $table->text('description')->nullable()->change();
        });
    }
};
