<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2)->default(0);
            $table->decimal('monthly_price', 10, 2)->nullable();
            $table->integer('duration_days')->default(30);
            $table->integer('discount_percentage')->default(0);
            $table->string('color')->default('#f97316');
            $table->string('icon')->nullable();
            $table->string('badge_text')->nullable();
            $table->integer('free_maintenance_visits')->default(0);
            $table->integer('warranty_months')->default(0);
            $table->boolean('priority_booking')->default(false);
            $table->boolean('support_24_7')->default(false);
            $table->boolean('is_active')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};





