<?php

namespace App\Models;

use Spatie\Permission\Models\Permission as SpatiePermission;

class Permission extends SpatiePermission
{
    protected $fillable = [
        'name',
        'guard_name',
        'name_ar',
        'name_en',
    ];

    /**
     * Get the translated name based on current locale
     */
    public function getTranslatedNameAttribute(): string
    {
        $locale = app()->getLocale();
        
        if ($locale === 'ar' && $this->name_ar) {
            return $this->name_ar;
        }
        
        if ($locale === 'en' && $this->name_en) {
            return $this->name_en;
        }
        
        // Fallback: Arabic first, then English, then technical name
        return $this->name_ar ?: ($this->name_en ?: $this->name);
    }

    /**
     * Get display name (Arabic preferred, then English, then technical name)
     */
    public function getDisplayNameAttribute(): string
    {
        return $this->name_ar ?: ($this->name_en ?: $this->name);
    }
}

