<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Spatie\Translatable\HasTranslations;

class PackageFeature extends Model
{
    use HasTranslations;

    protected $fillable = [
        'package_id',
        'feature',
        'icon',
        'sort_order',
    ];

    public $translatable = ['feature'];

    protected function casts(): array
    {
        return [
            'sort_order' => 'integer',
        ];
    }

    public function package(): BelongsTo
    {
        return $this->belongsTo(Package::class);
    }
}
