<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Translatable\HasTranslations;

class Package extends Model
{
    use HasTranslations;

    protected $fillable = [
        'name',
        'description',
        'price',
        'monthly_price',
        'duration_days',
        'discount_percentage',
        'color',
        'icon',
        'badge_text',
        'free_maintenance_visits',
        'warranty_months',
        'priority_booking',
        'support_24_7',
        'is_active',
        'is_featured',
        'sort_order',
    ];

    public $translatable = ['name', 'description', 'badge_text'];

    protected function casts(): array
    {
        return [
            'price' => 'decimal:2',
            'monthly_price' => 'decimal:2',
            'duration_days' => 'integer',
            'discount_percentage' => 'integer',
            'free_maintenance_visits' => 'integer',
            'warranty_months' => 'integer',
            'priority_booking' => 'boolean',
            'support_24_7' => 'boolean',
            'is_active' => 'boolean',
            'is_featured' => 'boolean',
            'sort_order' => 'integer',
        ];
    }

    public function categories(): BelongsToMany
    {
        return $this->belongsToMany(Category::class, 'category_package')
            ->withPivot('discount_percentage')
            ->withTimestamps();
    }

    public function features(): HasMany
    {
        return $this->hasMany(PackageFeature::class)->orderBy('sort_order');
    }

    public function subscriptions(): HasMany
    {
        return $this->hasMany(Subscription::class);
    }
}
