<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Spatie\Translatable\HasTranslations;

class AdditionalFacility extends Model
{
    use HasTranslations;

    protected $fillable = [
        'name',
        'price',
        'icon',
        'is_active',
        'sort_order',
    ];

    public $translatable = ['name'];

    protected function casts(): array
    {
        return [
            'price' => 'decimal:2',
            'is_active' => 'boolean',
            'sort_order' => 'integer',
        ];
    }

    public function subscriptions(): BelongsToMany
    {
        return $this->belongsToMany(Subscription::class, 'subscription_facilities')
            ->withPivot('quantity', 'unit_price', 'total_price')
            ->withTimestamps();
    }
}





