<?php

namespace App\Filament\Widgets;

use App\Filament\Resources\TechnicianResource;
use App\Models\Technician;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class TechniciansStatsWidget extends StatsOverviewWidget
{
    protected static ?int $sort = 2;
    
    // إخفاء الـ widget من الاكتشاف التلقائي (Dashboard)
    protected static bool $isDiscovered = false;

    protected function getStats(): array
    {
        $totalTechnicians = Technician::count();
        $activeTechnicians = Technician::where('is_active', true)->count();
        $inactiveTechnicians = Technician::where('is_active', false)->count();
        $totalOrders = Technician::withCount('orders')->get()->sum('orders_count');

        return [
            Stat::make('إجمالي الفنيين', $totalTechnicians)
                ->description('جميع الفنيين المسجلين')
                ->descriptionIcon('heroicon-m-wrench-screwdriver')
                ->color('primary')
                ->chart([2, 3, 4, 3, 5, 4, 6]),

            Stat::make('الفنيين النشطين', $activeTechnicians)
                ->description('فني متاح للعمل')
                ->descriptionIcon('heroicon-m-check-circle')
                ->color('success')
                ->chart([1, 2, 3, 2, 4, 3, 5]),

            Stat::make('الفنيين غير النشطين', $inactiveTechnicians)
                ->description('فني غير متاح')
                ->descriptionIcon('heroicon-m-x-circle')
                ->color('danger')
                ->chart([1, 1, 1, 1, 1, 1, 1]),

            Stat::make('إجمالي الطلبات', $totalOrders)
                ->description('طلبات تم تنفيذها')
                ->descriptionIcon('heroicon-m-shopping-cart')
                ->color('info')
                ->chart([5, 7, 8, 6, 9, 10, 8]),
        ];
    }
}
