<?php

namespace App\Filament\Widgets;

use App\Models\Subscription;
use Leandrocfe\FilamentApexCharts\Widgets\ApexChartWidget;

class SubscriptionsStatusChart extends ApexChartWidget
{
    protected static ?string $chartId = 'subscriptionsStatusChart';

    protected static ?string $heading = 'حالة الاشتراكات';

    protected static ?string $subheading = 'توزيع الاشتراكات حسب الحالة';

    protected static ?int $sort = 2;

    protected ?string $pollingInterval = '30s';

    protected function getOptions(): array
    {
        $active = Subscription::where('status', 'active')
            ->where('end_date', '>=', now()->toDateString())
            ->count();

        $expired = Subscription::where(function ($q) {
            $q->where('status', 'expired')
                ->orWhere(function ($q2) {
                    $q2->where('status', 'active')
                        ->where('end_date', '<', now()->toDateString());
                });
        })->count();

        $suspended = Subscription::where('status', 'suspended')->count();
        $cancelled = Subscription::where('status', 'cancelled')->count();

        return [
            'chart' => [
                'type' => 'donut',
                'height' => 320,
            ],
            'series' => [$active, $expired, $suspended, $cancelled],
            'labels' => ['نشط', 'منتهي', 'معلق', 'ملغي'],
            'colors' => ['#10b981', '#ef4444', '#f59e0b', '#6b7280'],
            'legend' => [
                'position' => 'bottom',
                'fontFamily' => 'inherit',
                'fontSize' => '14px',
            ],
            'plotOptions' => [
                'pie' => [
                    'donut' => [
                        'size' => '65%',
                        'labels' => [
                            'show' => true,
                            'total' => [
                                'show' => true,
                                'label' => 'الإجمالي',
                                'fontFamily' => 'inherit',
                                'fontSize' => '16px',
                                'fontWeight' => 600,
                            ],
                        ],
                    ],
                ],
            ],
            'dataLabels' => [
                'enabled' => true,
                'style' => [
                    'fontFamily' => 'inherit',
                    'fontWeight' => 600,
                ],
            ],
        ];
    }
}

