<?php

namespace App\Filament\Widgets;

use App\Models\Package;
use Leandrocfe\FilamentApexCharts\Widgets\ApexChartWidget;

class SubscriptionsByPackageChart extends ApexChartWidget
{
    protected static ?string $chartId = 'subscriptionsByPackageChart';

    protected static ?string $heading = 'الاشتراكات حسب الباقة';

    protected static ?string $subheading = 'عدد المشتركين في كل باقة';

    protected static ?int $sort = 4;

    protected ?string $pollingInterval = '30s';

    protected function getOptions(): array
    {
        $packages = Package::withCount([
            'subscriptions',
            'subscriptions as active_subscriptions_count' => function ($query) {
                $query->where('status', 'active')
                    ->where('end_date', '>=', now()->toDateString());
            },
        ])->orderBy('sort_order')->get();

        $labels = $packages->map(fn ($p) => $p->getTranslation('name', 'ar'))->toArray();
        $totalCounts = $packages->pluck('subscriptions_count')->toArray();
        $activeCounts = $packages->pluck('active_subscriptions_count')->toArray();
        $colors = $packages->pluck('color')->toArray();

        return [
            'chart' => [
                'type' => 'bar',
                'height' => 320,
                'toolbar' => [
                    'show' => false,
                ],
            ],
            'series' => [
                [
                    'name' => 'إجمالي الاشتراكات',
                    'data' => $totalCounts,
                ],
                [
                    'name' => 'اشتراكات نشطة',
                    'data' => $activeCounts,
                ],
            ],
            'xaxis' => [
                'categories' => $labels,
                'labels' => [
                    'style' => [
                        'fontFamily' => 'inherit',
                        'fontWeight' => 600,
                        'fontSize' => '13px',
                    ],
                ],
            ],
            'yaxis' => [
                'labels' => [
                    'style' => [
                        'fontFamily' => 'inherit',
                    ],
                ],
            ],
            'colors' => ['#6366f1', '#10b981'],
            'plotOptions' => [
                'bar' => [
                    'borderRadius' => 6,
                    'columnWidth' => '55%',
                    'dataLabels' => [
                        'position' => 'top',
                    ],
                ],
            ],
            'dataLabels' => [
                'enabled' => true,
                'offsetY' => -20,
                'style' => [
                    'fontFamily' => 'inherit',
                    'fontWeight' => 600,
                    'fontSize' => '12px',
                    'colors' => ['#374151'],
                ],
            ],
            'legend' => [
                'position' => 'top',
                'fontFamily' => 'inherit',
            ],
            'grid' => [
                'strokeDashArray' => 4,
            ],
        ];
    }
}

