<?php

namespace App\Filament\Widgets;

use App\Models\Client;
use App\Models\Category;
use App\Models\Order;
use App\Models\Package;
use App\Models\Service;
use App\Models\Subscription;
use App\Models\Technician;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class StatsOverview extends BaseWidget
{
    protected static ?int $sort = 1;

    protected function getStats(): array
    {
        $activeSubscriptions = Subscription::where('status', 'active')
            ->where('end_date', '>=', now()->toDateString())
            ->count();

        $subscriptionRevenue = Subscription::where('payment_status', 'paid')
            ->sum('amount_paid');

        // ربح التطبيق من الطلبات = رسوم التطبيق (fee) من الطلبات المكتملة
        $ordersFeeRevenue = Order::where('status', 'completed')
            ->sum('fee');

        // إجمالي قيمة الطلبات المكتملة
        $ordersTotal = Order::where('status', 'completed')
            ->sum('total');

        $totalRevenue = $subscriptionRevenue + $ordersFeeRevenue;

        $totalClients = Client::where('is_active', true)->count();

        $totalTechnicians = Technician::where('is_active', true)->count();

        $expiringSoon = Subscription::where('status', 'active')
            ->where('end_date', '<=', now()->addDays(7)->toDateString())
            ->where('end_date', '>=', now()->toDateString())
            ->count();

        return [
            Stat::make('إجمالي العملاء', $totalClients)
                ->description('عملاء نشطين')
                ->descriptionIcon('heroicon-m-users')
                ->color('success')
                ->chart([7, 3, 4, 5, 6, 3, 5]),

            Stat::make('الاشتراكات النشطة', $activeSubscriptions)
                ->description('اشتراك فعال حالياً')
                ->descriptionIcon('heroicon-m-credit-card')
                ->color('info')
                ->chart([3, 5, 2, 7, 4, 6, 5]),

            Stat::make('صافي ربح التطبيق', number_format($totalRevenue, 2) . ' ر.س')
                ->description('اشتراكات + رسوم الطلبات')
                ->descriptionIcon('heroicon-m-banknotes')
                ->color('warning')
                ->chart([4, 6, 8, 5, 7, 9, 8]),

            Stat::make('إيرادات الاشتراكات', number_format($subscriptionRevenue, 2) . ' ر.س')
                ->description('من الاشتراكات المدفوعة')
                ->descriptionIcon('heroicon-m-credit-card')
                ->color('success')
                ->chart([3, 5, 4, 6, 5, 7, 6]),

            Stat::make('رسوم التطبيق من الطلبات', number_format($ordersFeeRevenue, 2) . ' ر.س')
                ->description('رسوم التطبيق من الطلبات المكتملة')
                ->descriptionIcon('heroicon-m-receipt-percent')
                ->color('primary')
                ->chart([2, 4, 3, 5, 4, 6, 5]),

            Stat::make('إجمالي قيمة الطلبات', number_format($ordersTotal, 2) . ' ر.س')
                ->description('القيمة الكاملة للطلبات المكتملة')
                ->descriptionIcon('heroicon-m-shopping-cart')
                ->color('gray')
                ->chart([5, 7, 6, 8, 7, 9, 8]),

            Stat::make('الفنيين النشطين', $totalTechnicians)
                ->description('فني متاح')
                ->descriptionIcon('heroicon-m-wrench-screwdriver')
                ->color('primary')
                ->chart([2, 3, 4, 3, 5, 4, 6]),

            Stat::make('تنتهي قريباً', $expiringSoon)
                ->description('خلال 7 أيام')
                ->descriptionIcon('heroicon-m-exclamation-triangle')
                ->color('danger')
                ->chart([1, 2, 1, 3, 2, 1, 2]),

            Stat::make('الخدمات المتاحة', Service::where('is_active', true)->count())
                ->description('خدمة نشطة')
                ->descriptionIcon('heroicon-m-cog-6-tooth')
                ->color('success')
                ->chart([5, 5, 6, 8, 7, 9, 10]),
        ];
    }
}




