<?php

namespace App\Filament\Widgets;

use App\Models\Subscription;
use Leandrocfe\FilamentApexCharts\Widgets\ApexChartWidget;

class MonthlyRevenueChart extends ApexChartWidget
{
    protected static ?string $chartId = 'monthlyRevenueChart';

    protected static ?string $heading = 'الإيرادات الشهرية';

    protected static ?string $subheading = 'إيرادات الاشتراكات خلال آخر 6 أشهر';

    protected static ?int $sort = 3;

    protected ?string $pollingInterval = '60s';

    protected function getOptions(): array
    {
        $months = collect();
        $revenues = collect();
        $subscriptionCounts = collect();

        for ($i = 5; $i >= 0; $i--) {
            $date = now()->subMonths($i);
            $monthName = $this->getArabicMonth($date->month);
            $months->push($monthName);

            $monthRevenue = Subscription::where('payment_status', 'paid')
                ->whereYear('created_at', $date->year)
                ->whereMonth('created_at', $date->month)
                ->sum('amount_paid');

            $monthCount = Subscription::whereYear('created_at', $date->year)
                ->whereMonth('created_at', $date->month)
                ->count();

            $revenues->push(round($monthRevenue, 2));
            $subscriptionCounts->push($monthCount);
        }

        return [
            'chart' => [
                'type' => 'area',
                'height' => 320,
                'toolbar' => [
                    'show' => false,
                ],
            ],
            'series' => [
                [
                    'name' => 'الإيرادات (ر.س)',
                    'data' => $revenues->toArray(),
                    'type' => 'area',
                ],
                [
                    'name' => 'عدد الاشتراكات',
                    'data' => $subscriptionCounts->toArray(),
                    'type' => 'line',
                ],
            ],
            'xaxis' => [
                'categories' => $months->toArray(),
                'labels' => [
                    'style' => [
                        'fontFamily' => 'inherit',
                        'fontWeight' => 600,
                    ],
                ],
            ],
            'yaxis' => [
                [
                    'title' => [
                        'text' => 'الإيرادات (ر.س)',
                        'style' => [
                            'fontFamily' => 'inherit',
                        ],
                    ],
                    'labels' => [
                        'style' => [
                            'fontFamily' => 'inherit',
                        ],
                    ],
                ],
                [
                    'opposite' => true,
                    'title' => [
                        'text' => 'عدد الاشتراكات',
                        'style' => [
                            'fontFamily' => 'inherit',
                        ],
                    ],
                    'labels' => [
                        'style' => [
                            'fontFamily' => 'inherit',
                        ],
                    ],
                ],
            ],
            'colors' => ['#f59e0b', '#6366f1'],
            'stroke' => [
                'curve' => 'smooth',
                'width' => [2, 3],
            ],
            'fill' => [
                'type' => ['gradient', 'solid'],
                'gradient' => [
                    'shade' => 'light',
                    'type' => 'vertical',
                    'shadeIntensity' => 0.5,
                    'opacityFrom' => 0.5,
                    'opacityTo' => 0.1,
                ],
            ],
            'legend' => [
                'position' => 'top',
                'fontFamily' => 'inherit',
            ],
            'dataLabels' => [
                'enabled' => false,
            ],
            'grid' => [
                'strokeDashArray' => 4,
            ],
        ];
    }

    private function getArabicMonth(int $month): string
    {
        $months = [
            1 => 'يناير', 2 => 'فبراير', 3 => 'مارس',
            4 => 'أبريل', 5 => 'مايو', 6 => 'يونيو',
            7 => 'يوليو', 8 => 'أغسطس', 9 => 'سبتمبر',
            10 => 'أكتوبر', 11 => 'نوفمبر', 12 => 'ديسمبر',
        ];

        return $months[$month] ?? '';
    }
}

