<?php

namespace App\Filament\Technician\Resources\TechnicianOrderResource\Pages;

use App\Filament\Technician\Resources\TechnicianOrderResource;
use App\Models\Order;
use Filament\Actions\Action;
use Filament\Resources\Pages\ViewRecord;
use Filament\Forms\Components\Select;
use Filament\Notifications\Notification;

class ViewTechnicianOrder extends ViewRecord
{
    protected static string $resource = TechnicianOrderResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('changeStatus')
                ->label('تغيير الحالة')
                ->icon('heroicon-o-arrow-path')
                ->color('warning')
                ->form([
                    Select::make('status')
                        ->label('الحالة الجديدة')
                        ->options(function () {
                            $currentStatus = $this->record->status;
                            $options = [];

                            // الفني يقدر يغير حسب الحالة الحالية
                            if ($currentStatus === 'confirmed') {
                                $options['in_progress'] = 'قيد التنفيذ';
                            }
                            if ($currentStatus === 'in_progress') {
                                $options['completed'] = 'مكتمل';
                            }
                            if (in_array($currentStatus, ['pending', 'confirmed'])) {
                                $options['in_progress'] = 'قيد التنفيذ';
                            }

                            return $options;
                        })
                        ->required(),
                ])
                ->action(function (array $data) {
                    $this->record->update([
                        'status' => $data['status'],
                        'completed_date' => $data['status'] === 'completed' ? now() : $this->record->completed_date,
                    ]);

                    Notification::make()
                        ->title('تم تغيير الحالة بنجاح')
                        ->success()
                        ->send();
                })
                ->visible(fn () => in_array($this->record->status, ['pending', 'confirmed', 'in_progress'])),
        ];
    }
}


