<?php

namespace App\Filament\Technician\Pages;

use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;

class ReturnToAdmin extends Page
{
    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-o-arrow-uturn-left';

    protected static ?string $navigationLabel = 'العودة للأدمن';

    protected static ?string $title = 'العودة للأدمن';

    protected static ?int $navigationSort = 99;

    public static function shouldRegisterNavigation(): bool
    {
        return session()->has('impersonating_from_admin');
    }

    public function mount(): void
    {
        $adminId = session()->pull('impersonating_from_admin');

        Auth::guard('technician')->logout();

        if ($adminId) {
            Auth::guard('web')->loginUsingId($adminId);
        }

        $this->redirect('/admin/technicians');
    }
}


