<?php

namespace App\Filament\Resources\TechnicianResource\Pages;

use App\Filament\Resources\TechnicianResource;
use App\Filament\Widgets\TechniciansStatsWidget;
use Filament\Actions\Action;
use Filament\Actions\CreateAction;
use Filament\Resources\Pages\ListRecords;

class ListTechnicians extends ListRecords
{
    protected static string $resource = TechnicianResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('accessTechnicianPanel')
                ->label('لوحة تحكم الفني')
                ->icon('heroicon-o-arrow-top-right-on-square')
                ->color('info')
                ->url('/technician')
                ->openUrlInNewTab(),
            CreateAction::make(),
        ];
    }

    protected function getHeaderWidgets(): array
    {
        return [
            TechniciansStatsWidget::class,
        ];
    }
}




