<?php

namespace App\Filament\Resources\PropertyTypeResource\Pages;

use App\Filament\Resources\PropertyTypeResource;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditPropertyType extends EditRecord
{
    protected static string $resource = PropertyTypeResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $record = $this->getRecord();

        if ($record) {
            $nameTranslations = $record->getTranslations('name');
            $data['name'] = [
                'ar' => $nameTranslations['ar'] ?? '',
                'en' => $nameTranslations['en'] ?? '',
            ];
        }

        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        if (isset($data['name']) && is_array($data['name'])) {
            $data['name'] = [
                'ar' => $data['name']['ar'] ?? '',
                'en' => $data['name']['en'] ?? '',
            ];
        }

        return $data;
    }
}





