<?php

namespace App\Filament\Resources\PropertyTypeResource\Pages;

use App\Filament\Resources\PropertyTypeResource;
use Filament\Resources\Pages\CreateRecord;

class CreatePropertyType extends CreateRecord
{
    protected static string $resource = PropertyTypeResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        if (isset($data['name']) && is_array($data['name'])) {
            $data['name'] = [
                'ar' => $data['name']['ar'] ?? '',
                'en' => $data['name']['en'] ?? '',
            ];
        }

        return $data;
    }
}





