<?php

namespace App\Filament\Resources\PackageResource\Pages;

use App\Filament\Resources\PackageResource;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditPackage extends EditRecord
{
    protected static string $resource = PackageResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $record = $this->getRecord();

        if ($record) {
            $data['name'] = [
                'ar' => $record->getTranslation('name', 'ar', false) ?: '',
                'en' => $record->getTranslation('name', 'en', false) ?: '',
            ];

            $data['description'] = [
                'ar' => $record->getTranslation('description', 'ar', false) ?: null,
                'en' => $record->getTranslation('description', 'en', false) ?: null,
            ];

            $data['badge_text'] = [
                'ar' => $record->getTranslation('badge_text', 'ar', false) ?: null,
                'en' => $record->getTranslation('badge_text', 'en', false) ?: null,
            ];
        }

        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        if (isset($data['name']) && is_array($data['name'])) {
            $data['name'] = [
                'ar' => $data['name']['ar'] ?? '',
                'en' => $data['name']['en'] ?? '',
            ];
        }

        if (isset($data['description']) && is_array($data['description'])) {
            $data['description'] = [
                'ar' => $data['description']['ar'] ?? null,
                'en' => $data['description']['en'] ?? null,
            ];
        }

        if (isset($data['badge_text']) && is_array($data['badge_text'])) {
            $data['badge_text'] = [
                'ar' => $data['badge_text']['ar'] ?? null,
                'en' => $data['badge_text']['en'] ?? null,
            ];
        }

        return $data;
    }
}
