<?php

namespace App\Filament\Resources\PackageResource\Pages;

use App\Filament\Resources\PackageResource;
use Filament\Resources\Pages\CreateRecord;

class CreatePackage extends CreateRecord
{
    protected static string $resource = PackageResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        if (isset($data['name']) && is_array($data['name'])) {
            $data['name'] = [
                'ar' => $data['name']['ar'] ?? '',
                'en' => $data['name']['en'] ?? '',
            ];
        }

        if (isset($data['description']) && is_array($data['description'])) {
            $data['description'] = [
                'ar' => $data['description']['ar'] ?? null,
                'en' => $data['description']['en'] ?? null,
            ];
        }

        if (isset($data['badge_text']) && is_array($data['badge_text'])) {
            $data['badge_text'] = [
                'ar' => $data['badge_text']['ar'] ?? null,
                'en' => $data['badge_text']['en'] ?? null,
            ];
        }

        return $data;
    }
}
