<?php

namespace App\Filament\Resources\OrderResource\Pages;

use App\Filament\Resources\OrderResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditOrder extends EditRecord
{
    protected static string $resource = OrderResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        // حساب الإجمالي تلقائياً
        $data['total'] = ($data['price'] ?? 0) + ($data['fee'] ?? 0) - ($data['discount'] ?? 0);
        
        return $data;
    }
}


