<?php

namespace App\Filament\Resources\OrderResource\Pages;

use App\Filament\Resources\OrderResource;
use Filament\Resources\Pages\CreateRecord;

class CreateOrder extends CreateRecord
{
    protected static string $resource = OrderResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // حساب الإجمالي تلقائياً
        $data['total'] = ($data['price'] ?? 0) + ($data['fee'] ?? 0) - ($data['discount'] ?? 0);
        
        return $data;
    }
}


