<?php

namespace App\Filament\Resources\CategoryResource\Pages;

use App\Filament\Resources\CategoryResource;
use Filament\Resources\Pages\CreateRecord;

class CreateCategory extends CreateRecord
{
    protected static string $resource = CategoryResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // Filament sends nested arrays for dot-notation fields
        // name.ar => $data['name']['ar']
        if (isset($data['name']) && is_array($data['name'])) {
            $data['name'] = [
                'ar' => $data['name']['ar'] ?? '',
                'en' => $data['name']['en'] ?? '',
            ];
        }

        if (isset($data['description']) && is_array($data['description'])) {
            $data['description'] = [
                'ar' => $data['description']['ar'] ?? null,
                'en' => $data['description']['en'] ?? null,
            ];
        }

        return $data;
    }
}
