<?php

namespace App\Exports;

use App\Models\Service;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ServicesExport implements FromCollection, WithHeadings, WithMapping, WithStyles
{
    protected $services;

    public function __construct($services)
    {
        $this->services = $services;
    }

    public function collection()
    {
        return $this->services;
    }

    public function headings(): array
    {
        return [
            'اسم الخدمة (عربي)',
            'اسم الخدمة (إنجليزي)',
            'القسم',
            'السعر',
            'النقاط المكتسبة',
            'الحالة',
            'ترتيب العرض',
            'تاريخ الإنشاء',
        ];
    }

    public function map($service): array
    {
        $categoryName = $service->category
            ? ($service->category->getTranslation('name', 'ar') . ' / ' . $service->category->getTranslation('name', 'en'))
            : '-';

        return [
            $service->getTranslation('name', 'ar'),
            $service->getTranslation('name', 'en'),
            $categoryName,
            number_format($service->price, 2) . ' ر.س',
            $service->points ?? 0,
            $service->is_active ? 'نشط' : 'غير نشط',
            $service->sort_order ?? 0,
            $service->created_at->format('Y-m-d'),
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true, 'size' => 12]],
        ];
    }
}



