<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class SalesReportExport implements FromCollection, WithHeadings, WithMapping, WithStyles
{
    protected $orders;

    public function __construct($orders)
    {
        $this->orders = $orders;
    }

    public function collection()
    {
        return $this->orders;
    }

    public function headings(): array
    {
        return [
            'رقم الطلب',
            'تاريخ الطلب',
            'العميل',
            'الخدمة',
            'سعر الخدمة',
            'رسوم التطبيق',
            'الخصم',
            'إجمالي الطلب',
            'ربح التطبيق (الرسوم)',
            'الحالة',
        ];
    }

    public function map($order): array
    {
        return [
            $order->order_number,
            $order->created_at->format('Y-m-d'),
            $order->client->name ?? '-',
            $order->service ? $order->service->getTranslation('name', 'ar') : '-',
            number_format($order->price, 2) . ' ر.س',
            number_format($order->fee, 2) . ' ر.س',
            number_format($order->discount, 2) . ' ر.س',
            number_format($order->total, 2) . ' ر.س',
            number_format($order->fee, 2) . ' ر.س',
            $this->getStatusLabel($order->status),
        ];
    }

    protected function getStatusLabel($status): string
    {
        return match ($status) {
            'pending' => 'قيد الانتظار',
            'confirmed' => 'مؤكد',
            'in_progress' => 'قيد التنفيذ',
            'completed' => 'مكتمل',
            'cancelled' => 'ملغي',
            default => $status,
        };
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true, 'size' => 12]],
        ];
    }
}
