<?php

namespace App\Exports;

use App\Models\Client;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ClientsExport implements FromCollection, WithHeadings, WithMapping, WithStyles
{
    protected $clients;

    public function __construct($clients)
    {
        $this->clients = $clients;
    }

    public function collection()
    {
        return $this->clients;
    }

    public function headings(): array
    {
        return [
            'الاسم الكامل',
            'البريد الإلكتروني',
            'رقم الهاتف',
            'المدينة',
            'الجنس',
            'الحالة',
            'عدد الطلبات',
            'إجمالي المدفوع (طلبات مكتملة)',
            'رسوم التطبيق',
            'رصيد النقاط',
            'الباقة الحالية',
            'تاريخ انتهاء الاشتراك',
            'تاريخ التسجيل',
        ];
    }

    public function map($client): array
    {
        $activeSubscription = $client->active_subscription;
        $packageName = $activeSubscription && $activeSubscription->package
            ? $activeSubscription->package->getTranslation('name', 'ar')
            : '-';

        $endDate = $activeSubscription && $activeSubscription->end_date
            ? $activeSubscription->end_date->format('Y-m-d')
            : '-';

        return [
            $client->name,
            $client->email,
            $client->phone ?? '-',
            $client->city ?? '-',
            $client->gender === 'Male' ? 'ذكر' : ($client->gender === 'Female' ? 'أنثى' : '-'),
            $client->is_active ? 'نشط' : 'غير نشط',
            $client->orders_count ?? 0,
            number_format($client->orders_total ?? 0, 2) . ' ر.س',
            number_format($client->orders_fee ?? 0, 2) . ' ر.س',
            $client->points_balance ?? 0,
            $packageName,
            $endDate,
            $client->created_at->format('Y-m-d'),
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true, 'size' => 12]],
        ];
    }
}
